﻿if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;

if (typeof (MCS.SchedulingResource) == "undefined") {
    MCS.SchedulingResource = {};
}

MCS.SchedulingResource.LocationType = "";
MCS.SchedulingResource.TMPSite = "";  //.Id, .Name

MCS.SchedulingResource.OnLoad = function () {
    MCS.SchedulingResource.CheckParticipatingSite();
    MCS.SchedulingResource.SchedulingResourceTypeChange();

    //Make Fields read only if not createform
    if (Xrm.Page.ui.getFormType() != 1) {
        Xrm.Page.ui.controls.get("cvt_participatingsite").setDisabled(true);
        Xrm.Page.ui.controls.get("cvt_schedulingresourcetype").setDisabled(true);
        Xrm.Page.ui.controls.get("cvt_resourcetype").setDisabled(true);

        Xrm.Page.ui.controls.get("cvt_tmpresourcegroup").setDisabled(true);
        Xrm.Page.ui.controls.get("cvt_tmpresource").setDisabled(true);
        Xrm.Page.ui.controls.get("cvt_user").setDisabled(true);
    }
};
//Check for Participating Site for Pat or Pro
MCS.SchedulingResource.CheckParticipatingSite = function () {
    if (Xrm.Page.getAttribute("cvt_participatingsite").getValue() != null) {
        CrmRestKit.Retrieve('cvt_participatingsite', Xrm.Page.getAttribute("cvt_participatingsite").getValue()[0].id, ["cvt_locationtype", "cvt_site"], false).fail(function (err) {
            //alert("fail");
        }).done(function (data) {
            //alert("success");
            var locationType = data.d["cvt_locationtype"];
            MCS.SchedulingResource.TMPSite = data.d["cvt_site"];
            if (locationType && locationType.Value) {
                var schedulingResourceType = Xrm.Page.getControl("cvt_schedulingresourcetype");
                var resourceType = Xrm.Page.getControl("cvt_resourcetype");

                if (locationType.Value == 917290000) {
                    MCS.SchedulingResource.LocationType = "Provider";
                    schedulingResourceType.removeOption(3);                    
                    resourceType.removeOption(99999999);
                }
                else {
                    MCS.SchedulingResource.LocationType = "Patient";
                    schedulingResourceType.removeOption(2);
                    resourceType.removeOption(100000000);
                }
            }
        });
    }
};

//Orchestrate visible/required level of lookups
MCS.SchedulingResource.SchedulingResourceTypeChange = function () {
    var relatedResourceGroupControl = Xrm.Page.getControl("cvt_tmpresourcegroup");
    var relatedResourceControl = Xrm.Page.getControl("cvt_tmpresource");
    var relatedUserControl = Xrm.Page.getControl("cvt_user");
    var resourceTypeControl = Xrm.Page.getControl("cvt_resourcetype");

    var schedulingResourceType = Xrm.Page.getAttribute("cvt_schedulingresourcetype").getValue();
    var relatedResourceGroup = Xrm.Page.getAttribute("cvt_tmpresourcegroup");
    var relatedResource = Xrm.Page.getAttribute("cvt_tmpresource");
    var relatedUser = Xrm.Page.getAttribute("cvt_user");
    var resourceType = Xrm.Page.getAttribute("cvt_resourcetype");

    switch (schedulingResourceType) {
        case 0: //Resource Group
            relatedResourceGroupControl.setVisible(true);
            relatedResourceGroup.setRequiredLevel("required");
            //relatedResourceGroup.setValue();

            relatedResourceControl.setVisible(false);
            relatedResource.setRequiredLevel("none");
            relatedResource.setValue();

            relatedUserControl.setVisible(false);
            relatedUser.setRequiredLevel("none");
            relatedUser.setValue();

            resourceType.setValue();
            resourceTypeControl.setDisabled(false);
            break;
        case 1: //Single Resource
            relatedResourceGroupControl.setVisible(false);
            relatedResourceGroup.setRequiredLevel("none");
            relatedResourceGroup.setValue();

            relatedResourceControl.setVisible(true);
            relatedResource.setRequiredLevel("required");
            //relatedResource.setValue();

            relatedUserControl.setVisible(false);
            relatedUser.setRequiredLevel("none");
            relatedUser.setValue();

            resourceType.setValue();
            resourceTypeControl.setDisabled(false);
            break;
        case 2: //Single Provider
            relatedResourceGroupControl.setVisible(false);
            relatedResourceGroup.setRequiredLevel("none");
            relatedResourceGroup.setValue();

            relatedResourceControl.setVisible(false);
            relatedResource.setRequiredLevel("none");
            relatedResource.setValue();

            relatedUserControl.setVisible(true);
            relatedUser.setRequiredLevel("required");
            //relatedUser.setValue();

            resourceType.setValue(99999999);
            resourceTypeControl.setDisabled(true);
            break;
        case 3: //Single Telepresenter
            relatedResourceGroupControl.setVisible(false);
            relatedResourceGroup.setRequiredLevel("none");
            relatedResourceGroup.setValue();

            relatedResourceControl.setVisible(false);
            relatedResource.setRequiredLevel("none");
            relatedResource.setValue();

            relatedUserControl.setVisible(true);
            relatedUser.setRequiredLevel("required");
            //relatedUser.setValue();

            resourceType.setValue(100000000);
            resourceTypeControl.setDisabled(true);
            break;
        default:
            relatedResourceGroupControl.setVisible(false);
            relatedResourceGroup.setRequiredLevel("none");
            relatedResourceGroup.setValue();

            relatedResourceControl.setVisible(false);
            relatedResource.setRequiredLevel("none");
            relatedResource.setValue();

            relatedUserControl.setVisible(false);
            relatedUser.setRequiredLevel("none");
            relatedUser.setValue();

            resourceType.setValue();
            resourceTypeControl.setDisabled(false);
            break;
    }
};

//OnSave
MCS.SchedulingResource.CreateName = function () {
    var schedulingResourceType = Xrm.Page.getAttribute("cvt_schedulingresourcetype").getValue();
    var derivedResultField = "";

    switch (schedulingResourceType) {
        case 0: //Resource Group
            var relatedResourceGroup = Xrm.Page.getAttribute("cvt_tmpresourcegroup").getValue();
            if (relatedResourceGroup != null)
                derivedResultField = relatedResourceGroup[0].name;
            break;
        case 1: //Single Resource
            var relatedResource = Xrm.Page.getAttribute("cvt_tmpresource").getValue();
            if (relatedResource != null)
                derivedResultField = relatedResource[0].name;
            break;
        case 2: //Single Provider
        case 3: //Single Telepresenter
            var relatedUser = Xrm.Page.getAttribute("cvt_user").getValue();
            if (relatedUser != null)
                derivedResultField = relatedUser[0].name;
            Xrm.Page.getControl("cvt_resourcetype").setDisabled(false);
            break;
    }

    if (derivedResultField != Xrm.Page.getAttribute("cvt_name").getValue()) {
        Xrm.Page.getAttribute("cvt_name").setSubmitMode("always");
        Xrm.Page.getAttribute("cvt_name").setValue(derivedResultField);
    }
};

MCS.SchedulingResource.GetResourceType = function () {
    var relatedResourceGroup = Xrm.Page.getAttribute("cvt_tmpresourcegroup").getValue();
    var relatedResource = Xrm.Page.getAttribute("cvt_tmpresource").getValue();
    var relatedUser = Xrm.Page.getAttribute("cvt_user").getValue();

    if (relatedResourceGroup != null) {
        CrmRestKit.Retrieve('mcs_resourcegroup', Xrm.Page.getAttribute("cvt_tmpresourcegroup").getValue()[0].id, ["mcs_Type"], false).fail(function (err) {
            //alert("fail");
        }).done(function (data) {
            //alert("success");
            var type = data.d["mcs_Type"];
            if (type != null) {
                Xrm.Page.getAttribute("cvt_resourcetype").setValue(type.Value);
            }
        });
    }
    else if (relatedResource != null) {
        CrmRestKit.Retrieve('mcs_resource', Xrm.Page.getAttribute("cvt_tmpresource").getValue()[0].id, ["mcs_Type"], false).fail(function (err) {
            //alert("fail");
        }).done(function (data) {
            //alert("success");
            var type = data.d["mcs_Type"];
            if (type != null) {
                Xrm.Page.getAttribute("cvt_resourcetype").setValue(type.Value);
            }
        });
    }
    //else if (relatedUser != null)
    //    alert("User make sure Type is equivalent");
};

MCS.SchedulingResource.ModifyView = function () {
    var siteID = MCS.SchedulingResource.TMPSite.Id;
    var siteName = MCS.SchedulingResource.TMPSite.Name;
    var type = Xrm.Page.getAttribute("cvt_resourcetype").getValue();
    var tsaType = Xrm.Page.getAttribute("cvt_schedulingresourcetype").getValue();
    var ResourceGroupControl = Xrm.Page.getControl("cvt_tmpresourcegroup");
    var ResourceControl = Xrm.Page.getControl("cvt_tmpresource");
    var UserControl = Xrm.Page.getControl("cvt_user");


    var viewID = siteID;
    var ViewDisplayNameUser = "Filtered By Site";
    var ViewDisplayName = "Filtered by Site";
    var viewIsDefault = true;

    //Set up User view
    if (tsaType != null) {
        var UserfetchXml = '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="false"><entity name="systemuser"><attribute name="fullname"/><attribute name="title"/><attribute name="address1_telephone1"/><attribute name="businessunitid"/><attribute name="cvt_type"/><attribute name="systemuserid"/><order attribute="fullname" descending="false"/><filter type="and"><condition attribute="isdisabled" operator="eq" value="0"/><condition attribute="accessmode" operator="ne" value="3"/><condition attribute="cvt_site" operator="eq" uiname="' + formatXML(siteName) + '" uitype="mcs_site" value="' + siteID + '"/><condition attribute="cvt_type" operator="eq" value="';
        var UserlayoutXml = '<grid name="resultset" object="8" jump="fullname" select="1" icon="0" preview="0"><row name="result" id="systemuserid"><cell name="fullname" width="200" /><cell name="cvt_type" width="125" /><cell name="businessunitid" width="150" /><cell name="title" width="100" /><cell name="address1_telephone1" width="100" /></row></grid>';
        var RGlayoutXml = '<grid name="resultset" object="10007" jump="mcs_name" select="1" icon="0" preview="0"><row name="result" id="mcs_resourcegroupid"><cell name="mcs_name" width="200" /><cell name="mcs_relatedsiteid" width="125" /><cell name="mcs_type" width="125" /></row></grid>';
        var ResourcelayoutXml = '<grid name="resultset" object="10006" jump="mcs_name" select="1" icon="0" preview="0"><row name="result" id="mcs_resourceid"><cell name="mcs_name" width="200" /><cell name="mcs_relatedsiteid" width="125" /><cell name="mcs_type" width="125" /></row></grid>';

        switch (tsaType) {
            case 2:
                ViewDisplayNameUser += " and Providers";
                UserfetchXml += '917290001"/></filter></entity></fetch>';
                UserControl.addCustomView(viewID, "systemuser", ViewDisplayNameUser, UserfetchXml, UserlayoutXml, viewIsDefault);
                break;
            case 3:
                ViewDisplayNameUser += " and Telepresenter/Imager";
                UserfetchXml += '917290000"/></filter></entity></fetch>';
                UserControl.addCustomView(viewID, "systemuser", ViewDisplayNameUser, UserfetchXml, UserlayoutXml, viewIsDefault);
                break;
        }

        if (type != null) {
            ViewDisplayName += " and Type";

            var RGfetchXml = '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="false"><entity name="mcs_resourcegroup"><attribute name="mcs_resourcegroupid"/><attribute name="mcs_name"/><attribute name="createdon"/><order attribute="mcs_name" descending="false"/><filter type="and"><condition attribute="statecode" operator="eq" value="0"/><condition attribute="mcs_relatedsiteid" operator="eq" uiname="' + formatXML(siteName) + '" uitype="mcs_site" value="' + siteID + '"/><condition attribute="mcs_type" operator="eq" value="' + type + '"/></filter></entity></fetch>';
            ResourceGroupControl.addCustomView(viewID, "mcs_resourcegroup", ViewDisplayName, RGfetchXml, RGlayoutXml, viewIsDefault);

            var ResourcefetchXml = '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="false"><entity name="mcs_resource"><attribute name="mcs_resourceid"/><attribute name="mcs_name"/><attribute name="createdon"/><order attribute="mcs_name" descending="false"/><filter type="and"><condition attribute="statecode" operator="eq" value="0"/><condition attribute="mcs_relatedsiteid" operator="eq" uiname="' + formatXML(siteName) + '" uitype="mcs_site" value="' + siteID + '"/><condition attribute="mcs_type" operator="eq" value="' + type + '"/></filter></entity></fetch>';
            ResourceControl.addCustomView(viewID, "mcs_resource", ViewDisplayName, ResourcefetchXml, ResourcelayoutXml, viewIsDefault);
        }
        else
        {
            var RGfetchXml = '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="false"><entity name="mcs_resourcegroup"><attribute name="mcs_resourcegroupid"/><attribute name="mcs_name"/><attribute name="createdon"/><order attribute="mcs_name" descending="false"/><filter type="and"><condition attribute="statecode" operator="eq" value="0"/><condition attribute="mcs_relatedsiteid" operator="eq" uiname="' + formatXML(siteName) + '" uitype="mcs_site" value="' + siteID + '"/></filter></entity></fetch>';
            ResourceGroupControl.addCustomView(viewID, "mcs_resourcegroup", ViewDisplayName, RGfetchXml, RGlayoutXml, viewIsDefault);

            var ResourcefetchXml = '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="false"><entity name="mcs_resource"><attribute name="mcs_resourceid"/><attribute name="mcs_name"/><attribute name="createdon"/><order attribute="mcs_name" descending="false"/><filter type="and"><condition attribute="statecode" operator="eq" value="0"/><condition attribute="mcs_relatedsiteid" operator="eq" uiname="' + formatXML(siteName) + '" uitype="mcs_site" value="' + siteID + '"/></filter></entity></fetch>';
            ResourceControl.addCustomView(viewID, "mcs_resource", ViewDisplayName, ResourcefetchXml, ResourcelayoutXml, viewIsDefault);
        }
    }
};

 formatXML = function (str) {
     //replace & with &amp;
     if (str) {
         str = str.replace(/&/g, "&amp;");

         return str;
     }
 };

